﻿using System;
using System.Runtime.InteropServices;
using System.Text;

namespace UsingPointers
{
    class APIFileReader
    {
        const uint GenericRead = 0x80000000;
        const uint OpenExisting = 3;
        const uint UseDefault = 0;
        int fileHandle;

        [DllImport("kernel32", SetLastError = true)]
        static extern unsafe int CreateFile(
            string filename,
            uint desiredAccess,
            uint shareMode,
            uint attributes,
            uint creationDisposition,
            uint flagsAndAttributes,
            uint templateFile);

        [DllImport("kernel32", SetLastError = true)]
        static extern unsafe bool ReadFile(
            int hFile,
            void* lpBuffer,
            int nBytesToRead,
            int* nBytesRead,
            int overlapped);

        // Konstruktor otwiera istniejący plik
        // i ustawia wartość składowej fileHandle.
        public APIFileReader(string filename)
        {
            fileHandle = CreateFile(
                filename, // filename
                GenericRead, // desiredAccess
                UseDefault, // shareMode
                UseDefault, // attributes
                OpenExisting, // creationDisposition
                UseDefault, // flagsAndAttributes
                UseDefault); // templateFile
        }

        public unsafe int Read(byte[] buffer, int index, int count)
        {
            int bytesRead = 0;
            fixed (byte* bytePointer = buffer)
            {
                ReadFile(
                    fileHandle, // hfile
                    bytePointer + index, // lpBuffer
                    count, // nBytesToRead
                    &bytesRead, // nBytesRead
                    0); // overlapped
            }
            return bytesRead;
        }
    }
    class Test
    {
        public static void Main()
        {
            // Utworzenie obiektu klasy APIFileReader
            // i przekazanie do niego nazwy istniejącego pliku
            APIFileReader fileReader = new APIFileReader("houndofB.txt");

            // Utworzenie bufora i obiektu kodującego w kodzie ASCII
            const int BuffSize = 128;
            byte[] buffer = new byte[BuffSize];
            ASCIIEncoding asciiEncoder = new ASCIIEncoding();

            // Wczytanie pliku do bufora i wyświetlenie go w oknie konsoli
            while (fileReader.Read(buffer, 0, BuffSize) != 0)
            {
                Console.Write("{0}", asciiEncoder.GetString(buffer));
            }
        }
    }
}